/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.util.HashMap;
import sedona.Schema;
import sedona.Type;
import sedona.manifest.KitManifest;

public class Kit {
    public final Schema schema;
    public final int id;
    public final KitManifest manifest;
    public final String name;
    public final int checksum;
    public final Type[] types;
    final HashMap typesByName;

    public Type type(int n) {
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        boolean bl2 = false;
        if (n < this.types.length) {
            bl2 = true;
        }
        if (bl & bl2) {
            return this.types[n];
        }
        return null;
    }

    public Type type(String string) {
        return (Type)this.typesByName.get(string);
    }

    public String toString() {
        return this.name;
    }

    Kit(Schema schema, int n, KitManifest kitManifest) throws Exception {
        this.schema = schema;
        this.id = n;
        this.manifest = kitManifest;
        this.name = kitManifest.name;
        this.checksum = kitManifest.checksum;
        this.types = new Type[kitManifest.types.length];
        this.typesByName = new HashMap(this.types.length * 3);
        int n2 = 0;
        while (n2 < this.types.length) {
            String string = kitManifest.types[n2].qname;
            Type type = new Type(this, kitManifest.types[n2]);
            if (type.id != n2) {
                throw new Exception("Mismatched type id: " + string);
            }
            if (this.typesByName.get(type.name) != null) {
                throw new Exception("Duplicate type name: " + string);
            }
            this.types[n2] = type;
            this.typesByName.put(type.name, type);
            ++n2;
        }
    }
}

